"""
HB_BrushradiusDecrease V1.1

Last Modified: 10/01/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_BrushradiusDecrease
Description-US: Decrease the Brushradius of Tools and Objects

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=34m5s

Usage:
This Script works with all Tools that have a Radius-Parameter. You can use it also to influence the Radius of the HB_SmoothEdge-Script


ChangeLog:
Jun/11/2015 V1.0
- Release Version

Oct/01/2018 V1.1
- Python Rewrite
- Name changed to HB_BrushradiusDecrease (used to be HB_BrushradiusMinus)
- new Highres Icon



"""

import c4d
from c4d import documents, plugins
  

def tool():
        return plugins.FindPlugin(doc.GetAction(), c4d.PLUGINTYPE_TOOL)
    

def main():
    
    PlusFactor=0.6
    SelObj=doc.GetActiveObject()
    
    #SmoothEdge-Script Mode
    Tool_ID=doc.GetAction()

    if Tool_ID!=1016185 and SelObj:
        
        if SelObj.GetUp():
            if SelObj.GetUp().GetDown().GetName()=="HB_Smoothedge_Deformer":
                Deformer=SelObj.GetUp().GetDown()
                Deformer[c4d.SPLINEDEFORMEROBJECT_RADIUS]=Deformer[c4d.SPLINEDEFORMEROBJECT_RADIUS]*PlusFactor
                Deformer.Message(c4d.MSG_DESCRIPTION_VALIDATE) 
                
        if SelObj.GetDown():
            if SelObj.GetDown().GetName()=="HB_Smoothedge_Deformer":
                Deformer=SelObj.GetDown()
                Deformer[c4d.SPLINEDEFORMEROBJECT_RADIUS]=Deformer[c4d.SPLINEDEFORMEROBJECT_RADIUS]*PlusFactor
                Deformer.Message(c4d.MSG_DESCRIPTION_VALIDATE) 
            
    
    #BrushTool
    if Tool_ID==1016202:
 
        tool()[c4d.MDATA_BRUSH_FALLOFF_RADIUS]=tool()[c4d.MDATA_BRUSH_FALLOFF_RADIUS]*PlusFactor
    
    #SoftSelection
    if Tool_ID==200000088 or Tool_ID==200000089 or Tool_ID==200000090 :

        if tool()[c4d.MDATA_SOFT_ENABLE]:
       
            tool()[c4d.MDATA_SOFT_RADIUS]=float(tool()[c4d.MDATA_SOFT_RADIUS])*PlusFactor
        
    #MagnetTool
    if Tool_ID==1016185:
        tool()[c4d.MDATA_MAGNET_FALLOFF_RADIUS]=tool()[c4d.MDATA_MAGNET_FALLOFF_RADIUS]*PlusFactor
    
    #LiveSelection
    if Tool_ID==200000083:
        tool()[c4d.MDATA_SELECTLIVE_RADIUS]=int(tool()[c4d.MDATA_SELECTLIVE_RADIUS]*PlusFactor)
    
    #PaintTool
    if Tool_ID==1021286:
        tool()[c4d.ID_BRUSH_BASE_TOOL_RADIUS]=tool()[c4d.ID_BRUSH_BASE_TOOL_RADIUS]*PlusFactor

    #MographSelection
    if Tool_ID==1021340:
        tool()[c4d.MDATA_MGSELECTTOOL_RADIUS]=tool()[c4d.MDATA_MGSELECTTOOL_RADIUS]*PlusFactor


    #WeightTool
    if Tool_ID==1019499:
        tool()[c4d.ID_CA_WEIGHT_TOOL_RADIUS]=tool()[c4d.ID_CA_WEIGHT_TOOL_RADIUS]*PlusFactor
        
    #DoodleTool
    if Tool_ID==1022257:
  
        tool()[c4d.MDATA_DOODLE_SIZE]=tool()[c4d.MDATA_DOODLE_SIZE]*PlusFactor
    

    #DoodleEraser
    if Tool_ID==1022286:
        tool()[c4d.MDATA_DOODLE_SIZE]=tool()[c4d.MDATA_DOODLE_SIZE]*PlusFactor        
    
    
     #Hairselect
    if Tool_ID==1017448:
        tool()[c4d.HAIR_LIVESELECT_RADIUS]=tool()[c4d.HAIR_LIVESELECT_RADIUS]*PlusFactor
       
     #HairGuides
    if Tool_ID==1017640:
        tool()[c4d.HAIR_TOOL_ADDROOT_RADIUS]=tool()[c4d.HAIR_TOOL_ADDROOT_RADIUS]*PlusFactor
    
        

if __name__=='__main__':
    main()
    c4d.EventAdd()
